<?php
$active = intval($settings['active']);
$accordion = $widget->get_settings('accordion');
$wg_id = pxl_get_element_id($settings);
if(!empty($accordion)) : ?>
    <div class="pxl-accordion pxl-accordion1 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($accordion as $key => $value):
            $is_active = ($key + 1) == $active;
            $pxl_id = isset($value['_id']) ? $value['_id'] : '';
            $title = isset($value['title']) ? $value['title'] : '';
            $position1 = isset($value['position1']) ? $value['position1'] : '';
            $position2 = isset($value['position2']) ? $value['position2'] : '';
            $position3 = isset($value['position3']) ? $value['position3'] : '';
            $desc1 = isset($value['description1']) ? $value['description1'] : '';
            $desc2 = isset($value['description2']) ? $value['description2'] : '';
            $desc3 = isset($value['description3']) ? $value['description3'] : '';
            $number = isset($value['number']) ? $value['number'] : '';
            $btn_text = isset($value['btn_text']) ? $value['btn_text'] : '';
            $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
            $widget->add_render_attribute( $icon_key, [
                'class' => $value['pxl_icon'],
                'aria-hidden' => 'true',
            ] ); 
            $link = isset($value['link']) ? $value['link'] : [];

            ?>
            
            <div class="pxl--item <?php echo esc_attr($is_active ? 'active' : ''); ?>">
                <<?php pxl_print_html($settings['title_tag']); ?> class="pxl-accordion--title" data-target="<?php echo esc_attr('#'.$wg_id.'-'.$pxl_id); ?>">
                    <div class="pxl-title--number pxl-empty"><?php echo esc_html($number); ?></div>
                    <?php if ( ! empty( $value['pxl_icon']['value'] ) ) : ?>
                        <span class="pxl-title--icon pxl-mr-16">
                            <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                    <?php endif; ?>
                    <span class="pxl-title--text"><?php echo wp_kses_post($title); ?></span>
                    <?php if($settings['style'] == 'style-default') : ?><span class="pxl-icon--action">
                        <svg xmlns="http://www.w3.org/2000/svg" width="9" height="5" viewBox="0 0 9 5" fill="none">
                            <path d="M4.09154 3.18178L7.27392 0L8.18315 0.909084L4.09154 5L0 0.909084L0.909237 0L4.09154 3.18178Z" fill="#20282D"/>
                        </svg>
                    </span><?php endif; ?>
                </<?php pxl_print_html($settings['title_tag']); ?>>
                <div id="<?php echo esc_attr($wg_id.'-'.$pxl_id); ?>" class="pxl-accordion--content" <?php if($is_active){ ?>style="display: block;"<?php } ?>>
                    <div class="pxl-content1">
                        <div class="pxl-title1">
                            <?php echo wp_kses_post(nl2br($position1)); ?>
                        </div>
                        <div class="sub-title1">
                            <?php echo wp_kses_post(nl2br($desc1)); ?>
                        </div>
                    </div>
                    <div class="pxl-content2">
                        <div class="pxl-title2">
                            <?php echo wp_kses_post(nl2br($position2)); ?>
                        </div>
                        <div class="sub-title2">
                            <?php echo wp_kses_post(nl2br($desc2)); ?>
                        </div>
                    </div>
                    <div class="pxl-content3">
                        <div class="pxl-title3">
                            <?php echo wp_kses_post(nl2br($position3)); ?>
                        </div>
                        <div class="sub-title3">
                            <?php echo wp_kses_post(nl2br($desc3)); ?>
                        </div>
                    </div>
                    <div class="pxl-buttom-accordion">
                        <a class="btn-accordion" <?php logiku_render_link_attributes($link); ?> >
                            <div class="pxl--btn-text">
                                <?php echo pxl_print_html($btn_text); ?>
                            </div>
                            <div class="pxl--btn-icon">
                                <i class="pxl-icon--default flaticon flaticon-up-right-arrow"></i>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>