<?php
$active = intval($settings['active']);
$accordion = $widget->get_settings('accordion');
$wg_id = pxl_get_element_id($settings);
if(!empty($accordion)) : ?>
    <div class="pxl-accordion pxl-accordion3 <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($accordion as $key => $value):
            $is_active = ($key + 1) == $active;
            $pxl_id = isset($value['_id']) ? $value['_id'] : '';
            $title = isset($value['title']) ? $value['title'] : '';
            $position1 = isset($value['position1']) ? $value['position1'] : '';
            $position2 = isset($value['position2']) ? $value['position2'] : '';
            $position3 = isset($value['position3']) ? $value['position3'] : '';
            $desc1 = isset($value['description1']) ? $value['description1'] : '';
            $desc2 = isset($value['description2']) ? $value['description2'] : '';
            $desc3 = isset($value['description3']) ? $value['description3'] : '';
            $number = isset($value['number']) ? $value['number'] : '';
            $btn_text = isset($value['btn_text']) ? $value['btn_text'] : '';
            $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
            $widget->add_render_attribute( $icon_key, [
                'class' => $value['pxl_icon'],
                'aria-hidden' => 'true',
            ] ); 
            $link1 = isset($value['link_1']) ? $value['link_1'] : [];
            $link2 = isset($value['link_2']) ? $value['link_2'] : [];
            $link3 = isset($value['link_3']) ? $value['link_3'] : [];

            ?>
            
            <div class="pxl--item <?php echo esc_attr($is_active ? 'active' : ''); ?>">
                <<?php pxl_print_html($settings['title_tag']); ?> class="pxl-accordion--title" data-target="<?php echo esc_attr('#'.$wg_id.'-'.$pxl_id); ?>">
                    <div class="pxl-title--number pxl-empty"><?php echo esc_html($number); ?></div>
                    <?php if ( ! empty( $value['pxl_icon']['value'] ) ) : ?>
                        <span class="pxl-title--icon pxl-mr-16">
                            <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        </span>
                    <?php endif; ?>
                    <span class="pxl-title--text"><?php echo wp_kses_post($title); ?></span>
                    <?php if($settings['style'] == 'style-default') : ?><span class="pxl-icon--action">
                        <svg xmlns="http://www.w3.org/2000/svg" width="27" height="14" viewBox="0 0 27 14" fill="none">
                            <path d="M26.6364 7.6364C26.9879 7.28493 26.9879 6.71508 26.6364 6.36361L20.9088 0.636041C20.5574 0.284569 19.9875 0.284569 19.636 0.636041C19.2846 0.987513 19.2846 1.55736 19.636 1.90883L24.7272 7L19.636 12.0912C19.2846 12.4426 19.2846 13.0125 19.636 13.364C19.9875 13.7154 20.5574 13.7154 20.9088 13.364L26.6364 7.6364ZM0 7L-7.86805e-08 7.9L26 7.9L26 7L26 6.1L7.86805e-08 6.1L0 7Z" fill="#FA4729"/>
                        </svg>
                    </span><?php endif; ?>
                </<?php pxl_print_html($settings['title_tag']); ?>>
                <div id="<?php echo esc_attr($wg_id.'-'.$pxl_id); ?>" class="pxl-accordion--content" <?php if($is_active){ ?>style="display: block;"<?php } ?>>
                    <div class="pxl-content1">
                        <div class="pxl-title1">
                            <div class="title-1"><?php echo wp_kses_post(nl2br($position1)); ?></div>:
                        </div>
                        <div class="sub-title1">
                            <a <?php echo logiku_render_link_attributes($link1); ?>><?php echo wp_kses_post(nl2br($desc1)); ?></a>
                        </div>
                    </div>
                    <div class="pxl-content1">
                        <div class="pxl-title1">
                            <div class="title-1"><?php echo wp_kses_post(nl2br($position2)); ?></div>:
                        </div>
                        <div class="sub-title1">
                            <a <?php echo logiku_render_link_attributes($link2); ?>><?php echo wp_kses_post(nl2br($desc2)); ?></a>
                        </div>
                    </div>
                    <div class="pxl-content1">
                        <div class="pxl-title1">
                            <div class="title-1"><?php echo wp_kses_post(nl2br($position3)); ?></div>:
                        </div>
                        <div class="sub-title1">
                            <a <?php echo logiku_render_link_attributes($link3); ?>><?php echo wp_kses_post(nl2br($desc3)); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>