<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
    <div class="pxl-item-box pxl-item-box1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($settings['lists'] as $key => $value):?>
            <div class="item-box-item">
                <div class="pxl-item--inner">
                    <div class="pxl-item--holder">
                        <?php if(!empty($value['pxl_icon'])) {  ?>
                            <div class="pxl-item--icon">
                                <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                            </div>
                        <?php } ?>
                        <?php if(!empty($value['pxl_icon_1'])) {  ?>
                            <div class="pxl-item--icon1">
                                <?php \Elementor\Icons_Manager::render_icon( $value['pxl_icon_1'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                            </div>
                        <?php } ?>
                        <div class="conten-item">
                            <?php if(!empty($value['text'])) : ?>
                                <div class="pxl-item--text">
                                    <?php echo esc_attr($value['text']); ?>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-item--meta">
                                <h6 class="pxl-item--title el-empty">
                                    <?php if (!empty($value['link']['url'])): ?>
                                        <a href="<?php echo esc_url($value['link']['url']); ?>"<?php echo !empty($value['link']['is_external']) ? 'target="_blank"' : ''; ?><?php echo !empty($value['link']['nofollow']) ? 'rel="nofollow"' : ''; ?>>
                                    <?php endif; ?>
                                        <?php echo esc_attr($value['title']); ?>
                                    <?php if (!empty($value['link']['url'])): ?>
                                        </a>
                                    <?php endif; ?>
                                </h6>
                                <div class="pxl-item--content el-empty"><?php echo pxl_print_html($value['pxl_content']); ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>