<?php
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
if (isset($settings['list_content']) && !empty($settings['list_content']) && count($settings['list_content'])): ?>
    <div class="pxl-service8 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php foreach ($settings['list_content'] as $key => $value):
            $title = isset($value['title']) ? $value['title'] : '';
            $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
            $link = isset($value['link']) ? $value['link'] : [];
$link_url = isset($link['url']) ? $link['url'] : '';
            $icon_key = $widget->get_repeater_setting_key('pxl_icon', 'list_content', $key);
            $widget->add_render_attribute($icon_key, [
                'class' => $value['pxl_icon'],
                'aria-hidden' => 'true',
            ]); ?>
            <div class="pxl-item">
                <?php if (!empty($link_url)): ?>
                    <a <?php echo logiku_render_link_attributes($link); ?> class="pxl-service-inner">
                <?php endif; ?>
                <div class="pxl-service-item">
                    <?php if (!empty($value['image']['id'])):
                        $img = pxl_get_image_by_size([
                            'attach_id'  => $value['image']['id'],
                            'thumb_size' => '386x236',
                        ]);
                        if (!empty($img['thumbnail'])): ?>
                            <div class="service-image">
                                <?php echo pxl_print_html($img['thumbnail']); ?>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
    
                    <div class="pxl-service-title">
                        <?php if (!empty($value['pxl_icon'])): ?>
                            <div class="service-icon">
                                <?php if ($is_new):
                                    \Elementor\Icons_Manager::render_icon($value['pxl_icon'], ['aria-hidden' => 'true']);
                                else: ?>
                                    <i class="<?php echo esc_attr($value['pxl_icon']); ?>" aria-hidden="true"></i>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($title)): ?>
                            <h3 class="service-title"><?php echo esc_html($title); ?></h3>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if (!empty($link)): ?>
                </a>
                <?php endif; ?>
                <div class="pxl-service-content">
                    <?php if (!empty($sub_title)): ?>
                        <span class="service-subtitle"><?php echo esc_html($sub_title); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>