<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel1 <?php echo esc_attr($settings['style_l1']); ?>" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'logiku'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $position = isset($value['position']) ? $value['position'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $image = isset($value['image']) ? $value['image'] : '';
                        $icon_image = isset($value['icon_image']) ? $value['icon_image'] : '';
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <?php if(!empty($icon_image['id'])) { 
                                    $img_icon = pxl_get_image_by_size( array(
                                        'attach_id'  => $icon_image['id'],
                                        'thumb_size' => '30x30',
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail_icon = $img_icon['thumbnail'];?>
                                    <?php if($settings['style_l1'] == 'style-1') : ?>
                                        <div class="pxl-item--rating">
                                            <div class="pxl-item--icon pxl-mr-22">
                                                <?php echo wp_kses_post($thumbnail_icon); ?>
                                            </div>
                                            <div class="pxl-item--star text-gradient pxl-item--flexnw pxl-mr-22">
                                                <span class="pxl-star--inner">
                                                    <?php for ($i = 0; $i < 5; $i++): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php endfor; ?>
                                                </span>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php } ?>
                                <div class="testimonial-stars">
                                    <span class="pxl-star--inner">
                                        <?php for ($i = 0; $i < 5; $i++): ?>
                                            <i class="fas fa-star"></i>
                                        <?php endfor; ?>
                                    </span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="83" height="27" viewBox="0 0 83 27" fill="none">
                                    <g clip-path="url(#clip0_115_25)">
                                    <path d="M80.4152 16.5008L82.7177 18.0225C81.9704 19.1138 80.183 20.986 77.0928 20.986C73.2553 20.986 70.3974 18.0426 70.3974 14.2982C70.3974 10.3135 73.2856 7.61035 76.7696 7.61035C80.2739 7.61035 81.9906 10.3736 82.546 11.8653L82.849 12.6262L73.8208 16.3306C74.5075 17.6721 75.578 18.3529 77.0928 18.3529C78.6076 18.3529 79.6578 17.6121 80.4152 16.5008ZM73.3361 14.0879L79.365 11.605C79.0317 10.7741 78.0421 10.1834 76.8605 10.1834C75.3558 10.1834 73.2654 11.5049 73.3361 14.0879Z" fill="#FF302F"/>
                                    <path d="M66.0449 0.791992H68.9533V20.3749H66.0449V0.791992Z" fill="#20B15A"/>
                                    <path d="M61.4596 8.13023H64.2671V20.0241C64.2671 24.9599 61.3284 26.9923 57.8544 26.9923C54.5825 26.9923 52.6132 24.8097 51.876 23.0377L54.4512 21.9764C54.9157 23.0677 56.0367 24.3592 57.8544 24.3592C60.0862 24.3592 61.4596 22.9876 61.4596 20.4246V19.4635H61.3587C60.6921 20.2644 59.4197 20.9853 57.8039 20.9853C54.431 20.9853 51.3408 18.0719 51.3408 14.3175C51.3408 10.5431 54.431 7.59961 57.8039 7.59961C59.4096 7.59961 60.6921 8.31044 61.3587 9.09135H61.4596V8.13023ZM61.6616 14.3175C61.6616 11.9547 60.0761 10.2327 58.0564 10.2327C56.0165 10.2327 54.2997 11.9547 54.2997 14.3175C54.2997 16.6502 56.0165 18.3422 58.0564 18.3422C60.0761 18.3522 61.6616 16.6502 61.6616 14.3175Z" fill="#3686F7"/>
                                    <path d="M35.3754 14.2672C35.3754 18.1217 32.3458 20.955 28.6295 20.955C24.9132 20.955 21.8836 18.1117 21.8836 14.2672C21.8836 10.3926 24.9132 7.56934 28.6295 7.56934C32.3458 7.56934 35.3754 10.3926 35.3754 14.2672ZM32.4266 14.2672C32.4266 11.8644 30.6694 10.2124 28.6295 10.2124C26.5896 10.2124 24.8324 11.8644 24.8324 14.2672C24.8324 16.65 26.5896 18.3219 28.6295 18.3219C30.6694 18.3219 32.4266 16.65 32.4266 14.2672Z" fill="#FF302F"/>
                                    <path d="M50.1089 14.2972C50.1089 18.1517 47.0794 20.985 43.3631 20.985C39.6468 20.985 36.6172 18.1517 36.6172 14.2972C36.6172 10.4227 39.6468 7.60938 43.3631 7.60938C47.0794 7.60938 50.1089 10.4127 50.1089 14.2972ZM47.1501 14.2972C47.1501 11.8944 45.3929 10.2425 43.353 10.2425C41.313 10.2425 39.5559 11.8944 39.5559 14.2972C39.5559 16.68 41.313 18.3519 43.353 18.3519C45.403 18.3519 47.1501 16.67 47.1501 14.2972Z" fill="#FFBA40"/>
                                    <path d="M10.7953 18.0521C6.56401 18.0521 3.25167 14.6681 3.25167 10.4732C3.25167 6.27831 6.56401 2.89435 10.7953 2.89435C13.0776 2.89435 14.7439 3.7854 15.9759 4.92673L18.0057 2.91438C16.289 1.28247 13.9966 0.0410156 10.7953 0.0410156C4.99873 0.0410156 0.121094 4.7265 0.121094 10.4732C0.121094 16.2199 4.99873 20.9054 10.7953 20.9054C13.9259 20.9054 16.289 19.8842 18.137 17.982C20.0356 16.0998 20.6213 13.4567 20.6213 11.3142C20.6213 10.6434 20.5405 9.95261 20.4496 9.44201H10.7953V12.2253H17.6725C17.4705 13.9673 16.9151 15.1587 16.0971 15.9697C15.1074 16.9608 13.5422 18.0521 10.7953 18.0521Z" fill="#3686F7"/>
                                    </g>
                                    <defs>
                                    <clipPath id="clip0_115_25">
                                    <rect width="83" height="27" fill="white"/>
                                    </clipPath>
                                    </defs>
                                    </svg>
                                </div>
                                <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                                <div class="pxl-item--holder pxl-item--flexnw">
                                    <?php if(!empty($image['id'])) { 
                                        $img = pxl_get_image_by_size( array(
                                            'attach_id'  => $image['id'],
                                            'thumb_size' => '60x60',
                                            'class' => 'no-lazyload',
                                        ));
                                        $thumbnail = $img['thumbnail'];?>
                                        <div class="pxl-item--avatar pxl-mr-18">
                                            <?php echo wp_kses_post($thumbnail); ?>
                                        </div>
                                    <?php } ?>
                                    <div class="pxl-item--meta">
                                        <h5 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h5>
                                        <div class="pxl-item--position el-empty"><?php echo pxl_print_html($position); ?></div>
                                    </div>
                                    <?php if($settings['style_l1'] == 'style-2') : ?>
                                        <div class="pxl-item--rating pxl-ml-20 pxl-screen--lg">
                                            <div class="pxl-item--icon pxl-mr-22">
                                                <?php echo wp_kses_post($thumbnail_icon); ?>
                                            </div>
                                            <div class="pxl-item--star text-gradient pxl-item--flexnw">
                                                <span class="pxl-star--inner">
                                                    <?php for ($i = 0; $i < 5; $i++): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php endfor; ?>
                                                </span>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php if($settings['style_l1'] == 'style-2') : ?>
                                    <div class="pxl-item--rating pxl-ml-20 pxl-screen--md">
                                        <div class="pxl-item--icon pxl-mr-22">
                                            <?php echo wp_kses_post($thumbnail_icon); ?>
                                        </div>
                                        <div class="pxl-item--star text-gradient pxl-item--flexnw">
                                            <span class="pxl-star--inner">
                                                <?php for ($i = 0; $i < 5; $i++): ?>
                                                    <i class="fas fa-star"></i>
                                                <?php endfor; ?>
                                            </span>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="logo-meta">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="127" height="127" viewBox="0 0 127 127" fill="none">
                                    <path d="M0 15.875V111.125L47.625 63.5V15.875H0Z" fill="#FA4729" fill-opacity="0.1"/>
                                    <path d="M79.375 15.875V111.125L127 63.5V15.875H79.375Z" fill="#FA4729" fill-opacity="0.1"/>
                                    </svg>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

        </div>
        
        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-1">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev pxl-cursor--cta"><i class="far fa-arrow-left"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next pxl-cursor--cta"><i class="far fa-arrow-right"></i></div>
            </div>
        <?php endif; ?>
        
    </div>
<?php endif; ?>
