<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel3" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'logiku'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                <?php foreach ($settings['testimonial'] as $key => $value):
                    $title = isset($value['title']) ? $value['title'] : '';
                    $title1 = isset($value['title1']) ? $value['title1'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    ?>
                    <div class="pxl-swiper-slide">
                        <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>">
                            <div class="pxl-item--holder">
                                <?php if(!empty($image['id'])) { 
                                    $img = pxl_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => '128x128',
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail = $img['thumbnail'];?>
                                    <div class="pxl-item--avatar pxl-mr-18">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    </div>
                                <?php } ?>
                                <div class="pxl-item--meta pxl-mr-20">
                                    <h6 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h6>
                                    <?php if(!empty($position)) : ?>
                                        <div class="pxl-item--position"><?php echo pxl_print_html($position); ?></div>
                                    <?php endif; ?>
                                </div>
                                <div class="pxl-item--icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="112" height="50" viewBox="0 0 112 50" fill="none">
                                        <path d="M34.9453 11.7764H44.0311V13.5278H40.5366V22.9853H38.4399V13.5278H34.9453V11.7764ZM43.5069 14.7537H45.2542V16.33C45.2542 16.1549 45.4289 15.9797 45.6037 15.6294C45.7784 15.2792 45.9531 15.2792 46.1278 15.104C46.3026 14.9289 46.652 14.7537 46.8267 14.7537C47.0015 14.5786 47.3509 14.5786 47.7004 14.5786C47.8751 14.5786 48.0498 14.5786 48.0498 14.5786H48.2246V16.33C48.0498 16.33 48.0498 16.33 47.8751 16.33C47.7004 16.33 47.7004 16.33 47.5257 16.33C47.1762 16.33 47.0015 16.33 46.652 16.5051C46.3026 16.6803 46.1278 16.8554 45.9531 17.0306C45.7784 17.2057 45.6037 17.556 45.4289 17.9063C45.2542 18.2565 45.2542 18.6068 45.2542 19.1322V22.9853H43.5069V14.7537ZM56.4367 22.9853H54.6895V21.9345C54.5147 22.2847 54.1653 22.635 53.6411 22.9853C53.2916 23.1604 52.7675 23.3356 52.2433 23.3356C51.1949 23.3356 50.496 23.1604 49.9718 22.4599C49.4477 21.7593 49.2729 21.0588 49.2729 20.0079V14.9289H51.0202V19.8328C51.0202 20.5333 51.1949 21.0588 51.3696 21.409C51.7191 21.7593 52.0686 21.9345 52.5927 21.9345C52.9422 21.9345 53.2916 21.9345 53.4664 21.7593C53.6411 21.5842 53.9906 21.409 53.9906 21.2339C54.1653 21.0588 54.34 20.8836 54.34 20.5333C54.34 20.1831 54.5147 20.0079 54.5147 19.6577V14.9289H56.262V22.9853H56.4367ZM59.4071 20.3582C59.4071 20.8836 59.5818 21.2339 59.9313 21.409C60.2807 21.5842 60.6302 21.7593 61.1544 21.7593C61.3291 21.7593 61.5038 21.7593 61.6785 21.7593C61.8533 21.7593 62.028 21.7593 62.2027 21.5842C62.3774 21.5842 62.5522 21.409 62.7269 21.2339C62.9016 21.0588 62.9016 20.8836 62.9016 20.7085C62.9016 20.5333 62.7269 20.3582 62.7269 20.1831C62.5522 20.0079 62.3774 20.0079 62.2027 19.8328C62.028 19.8328 61.6785 19.6577 61.3291 19.6577C60.9796 19.6577 60.6302 19.4825 60.4554 19.4825C60.106 19.4825 59.7565 19.3074 59.5818 19.1322C59.4071 18.9571 59.0576 18.9571 58.7082 18.782C58.5335 18.6068 58.184 18.4317 58.184 18.0814C58.0093 17.7311 58.0093 17.3808 58.0093 17.0306C58.0093 16.5051 58.184 16.1549 58.3587 15.9797C58.5335 15.8046 58.8829 15.4543 59.2324 15.2792C59.5818 15.104 59.9313 14.9289 60.2807 14.9289C60.6302 14.9289 61.1544 14.7537 61.5038 14.7537C61.8533 14.7537 62.3775 14.7537 62.7269 14.9289C63.0764 14.9289 63.4258 15.104 63.7753 15.2792C64.1247 15.4543 64.2994 15.8046 64.4742 15.9797C64.6489 16.33 64.8236 16.6803 64.8236 17.2057H62.9016C62.9016 16.8554 62.5522 16.5051 62.3774 16.33C61.8533 16.1549 61.5038 15.9797 61.1544 15.9797C60.9796 15.9797 60.8049 15.9797 60.6302 15.9797C60.4555 15.9797 60.2807 15.9797 60.106 16.1549C59.9313 16.1549 59.7565 16.33 59.7565 16.33C59.5818 16.5051 59.5818 16.5051 59.5818 16.6803C59.5818 16.8554 59.5818 17.0306 59.7565 17.2057C59.9313 17.3808 60.106 17.3808 60.2807 17.556C60.4555 17.556 60.8049 17.7311 61.1544 17.7311C61.5038 17.7311 61.8533 17.9063 62.2027 17.9063C62.5522 17.9063 62.9016 18.0814 63.0764 18.2565C63.4258 18.4317 63.6005 18.4317 63.95 18.6068C64.2994 18.782 64.4742 18.9571 64.4742 19.3074C64.6489 19.6576 64.6489 19.8328 64.6489 20.3582C64.6489 20.8836 64.4742 21.2339 64.2994 21.5842C64.1247 21.9345 63.7753 22.1096 63.4258 22.4599C63.2511 22.8102 62.9016 22.9853 62.5522 22.9853C62.2027 22.9853 61.6785 23.1604 61.3291 23.1604C60.8049 23.1604 60.2807 23.1604 59.9313 22.9853C59.5818 22.8102 59.0576 22.635 58.8829 22.4599C58.5335 22.2847 58.3587 21.9345 58.184 21.5842C57.8345 21.2339 57.6598 20.8836 57.6598 20.3582H59.4071ZM65.3478 14.7537H66.7456V12.4769H68.4929V14.9289H70.0654V16.33H68.4929V20.7085C68.4929 20.8836 68.4929 21.0588 68.4929 21.2339C68.4929 21.409 68.4929 21.409 68.6676 21.5842C68.8423 21.7593 68.8424 21.7593 68.8424 21.7593C69.0171 21.7593 69.1918 21.7593 69.3665 21.7593C69.5413 21.7593 69.5413 21.7593 69.716 21.7593C69.8907 21.7593 69.8907 21.7593 70.0654 21.7593V22.9853C69.8907 22.9853 69.716 22.9853 69.5413 22.9853C69.3665 22.9853 69.1918 22.9853 69.0171 22.9853C68.4929 22.9853 68.1434 22.9853 67.9687 22.8102C67.6193 22.8102 67.4445 22.635 67.2698 22.4599C67.0951 22.2847 66.9203 22.1096 66.9203 21.7593C66.9203 21.5842 66.7456 21.2339 66.7456 20.8836V16.1549H65.3478V14.7537ZM71.2885 14.7537H73.0358V15.9797C73.2105 15.4543 73.56 15.104 74.0842 14.9289C74.6083 14.7537 74.9578 14.5786 75.482 14.5786C76.1809 14.5786 76.7051 14.7537 77.2292 14.9289C77.7534 15.104 78.1029 15.4543 78.4523 15.8046C78.8018 16.1549 78.9765 16.6803 79.1512 17.2057C79.326 17.7311 79.326 18.2565 79.326 18.9571C79.326 19.4825 79.326 20.0079 79.1512 20.5333C78.9765 21.0588 78.8018 21.409 78.4523 21.9345C78.1029 22.2847 77.7534 22.635 77.404 22.8102C76.8798 22.9853 76.5303 23.1604 75.8314 23.1604C75.6567 23.1604 75.3072 23.1604 75.1325 23.1604C74.9578 23.1604 74.6083 22.9853 74.4336 22.9853C74.2589 22.8102 73.9094 22.8102 73.7347 22.635C73.56 22.4599 73.3853 22.2847 73.2105 22.1096V26.1378H71.4633V14.7537H71.2885ZM77.5787 18.9571C77.5787 18.6068 77.5787 18.2565 77.404 17.9063C77.2292 17.556 77.2292 17.2057 77.0545 17.0306C76.8798 16.8554 76.7051 16.5051 76.3556 16.33C76.0062 16.1549 75.8314 16.1549 75.3072 16.1549C74.6083 16.1549 73.9094 16.33 73.56 16.8554C73.2105 17.3808 73.0358 18.0814 73.0358 18.9571C73.0358 19.3074 73.0358 19.8328 73.2105 20.0079C73.3853 20.3582 73.3853 20.7085 73.7347 20.8836C73.9094 21.0588 74.0842 21.409 74.4336 21.409C74.7831 21.5842 74.9578 21.5842 75.3072 21.5842C75.6567 21.5842 76.0062 21.5842 76.3556 21.409C76.7051 21.2339 76.8798 21.0588 77.0545 20.7085C77.2292 20.3582 77.404 20.1831 77.404 19.8328C77.404 19.6577 77.5787 19.3074 77.5787 18.9571ZM80.7238 11.7764H82.4711V13.5278H80.7238V11.7764ZM80.7238 14.7537H82.4711V22.9853H80.7238V14.7537ZM84.0436 11.7764H85.7909V22.9853H84.0436V11.7764ZM91.2074 23.1604C90.5085 23.1604 89.9843 22.9853 89.4601 22.8102C88.9359 22.635 88.5865 22.2847 88.237 21.9345C87.8876 21.5842 87.5381 21.0588 87.3634 20.5333C87.1887 20.0079 87.014 19.4825 87.014 18.782C87.014 18.0814 87.1887 17.556 87.3634 17.0306C87.5381 16.5051 87.8876 15.9797 88.237 15.6294C88.5865 15.2792 88.9359 14.9289 89.4601 14.7537C89.9843 14.5786 90.5085 14.4035 91.2074 14.4035C91.9063 14.4035 92.4305 14.5786 92.9547 14.7537C93.4789 14.9289 93.8283 15.2792 94.1778 15.6294C94.5272 15.9797 94.8767 16.5051 95.0514 17.0306C95.2261 17.556 95.4008 18.0814 95.4008 18.782C95.4008 19.4825 95.2261 20.0079 95.0514 20.5333C94.8767 21.0588 94.5272 21.5842 94.1778 21.9345C93.8283 22.2847 93.4789 22.635 92.9547 22.8102C92.4305 22.9853 91.9063 23.1604 91.2074 23.1604ZM91.2074 21.7593C91.5569 21.7593 91.9063 21.7593 92.2558 21.5842C92.6052 21.409 92.7799 21.2339 92.9547 20.8836C93.1294 20.5333 93.3041 20.3582 93.3041 20.0079C93.3041 19.6576 93.4788 19.3074 93.4788 18.9571C93.4788 18.6068 93.4789 18.2565 93.3041 17.9063C93.3041 17.556 93.1294 17.2057 92.9547 17.0306C92.7799 16.8554 92.6052 16.5051 92.2558 16.33C91.9063 16.1549 91.5569 16.1549 91.2074 16.1549C90.8579 16.1549 90.5085 16.1549 90.159 16.33C89.8096 16.5051 89.6349 16.6803 89.4601 17.0306C89.2854 17.3808 89.1107 17.556 89.1107 17.9063C89.1107 18.2565 88.936 18.6068 88.936 18.9571C88.936 19.3074 88.9359 19.6576 89.1107 20.0079C89.1107 20.3582 89.2854 20.7085 89.4601 20.8836C89.6349 21.2339 89.8096 21.409 90.159 21.5842C90.5085 21.5842 90.8579 21.7593 91.2074 21.7593ZM95.925 14.7537H97.3228V12.4769H99.0701V14.9289H100.643V16.33H99.0701V20.7085C99.0701 20.8836 99.0701 21.0588 99.0701 21.2339C99.0701 21.409 99.0701 21.409 99.2448 21.5842C99.4196 21.7593 99.4196 21.7593 99.4196 21.7593C99.5943 21.7593 99.769 21.7593 99.9437 21.7593C100.118 21.7593 100.118 21.7593 100.293 21.7593C100.468 21.7593 100.468 21.7593 100.643 21.7593V22.9853C100.468 22.9853 100.293 22.9853 100.118 22.9853C99.9437 22.9853 99.769 22.9853 99.5943 22.9853C99.0701 22.9853 98.7207 22.9853 98.5459 22.8102C98.1965 22.8102 98.0218 22.635 97.847 22.4599C97.6723 22.2847 97.4976 22.1096 97.4976 21.7593C97.4976 21.5842 97.3228 21.2339 97.3228 20.8836V16.1549H95.925V14.7537Z" fill="#191919"/>
                                        <path d="M32.8479 11.7768H24.6358L22.1896 3.89551L19.5687 11.7768H11.5312L17.9961 16.5056L15.55 24.3868L22.1896 19.4829L28.6545 24.3868L26.2083 16.5056L32.8479 11.7768Z" fill="#00B67A"/>
                                        <path d="M26.7343 18.2574L26.2101 16.506L22.1914 19.4834L26.7343 18.2574Z" fill="#005128"/>
                                        <path d="M28.305 29.291H11.5312V46.1044H28.305V29.291Z" fill="#00B67A"/>
                                        <path d="M46.3011 29.291H29.5273V46.1044H46.3011V29.291Z" fill="#00B67A"/>
                                        <path d="M64.473 29.291H47.6992V46.1044H64.473V29.291Z" fill="#00B67A"/>
                                        <path d="M82.4691 29.291H65.6953V46.1044H82.4691V29.291Z" fill="#00B67A"/>
                                        <path d="M100.641 29.291H83.8672V46.1044H100.641V29.291Z" fill="#DCDCE6"/>
                                        <path d="M83.8672 29.291H92.2541V45.9293H83.8672V29.291Z" fill="#00B67A"/>
                                        <path d="M19.7426 40.4993L22.3635 39.7987L23.4118 43.1264L19.7426 40.4993ZM25.6833 36.2959H21.1404L19.7426 32.0926L18.3447 36.2959H13.9766L17.6458 38.923L16.248 43.1264L19.9173 40.4993L22.1887 38.923L25.6833 36.2959Z" fill="white"/>
                                        <path d="M37.9162 40.4993L40.5371 39.7987L41.5855 43.1264L37.9162 40.4993ZM43.6822 36.2959H39.1393L37.7415 32.0926L36.3437 36.2959H31.8008L35.47 38.923L34.0722 43.1264L37.7415 40.4993L40.0129 38.923L43.6822 36.2959Z" fill="white"/>
                                        <path d="M56.0881 40.4993L58.709 39.7987L59.7574 43.1264L56.0881 40.4993ZM61.8541 36.2959H57.3112L55.9134 32.0926L54.5156 36.2959H49.9727L53.6419 38.923L52.4188 43.1264L56.0881 40.4993L58.3596 38.923L61.8541 36.2959Z" fill="white"/>
                                        <path d="M74.0853 40.4993L76.7062 39.7987L77.7545 43.1264L74.0853 40.4993ZM80.026 36.2959H75.4831L74.0853 32.0926L72.6874 36.2959H68.1445L71.8138 38.923L70.416 43.1264L74.0853 40.4993L76.3567 38.923L80.026 36.2959Z" fill="white"/>
                                        <path d="M92.2532 40.4993L94.8741 39.7987L95.9225 43.1264L92.2532 40.4993ZM98.0192 36.2959H93.4763L92.0785 32.0926L90.8554 36.2959H86.3125L89.9818 38.923L88.5839 43.1264L92.2532 40.4993L94.5247 38.923L98.0192 36.2959Z" fill="white"/>
                                    </svg>
                                </div>
                            </div>
                            <div class="pxl-title-inner">
                                <div class="pxl-item-svg">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="56" height="56" viewBox="0 0 56 56" fill="none">
                                        <path d="M0 7V49L21 28V7H0Z" fill="#FA4729"/>
                                        <path d="M35 7V49L56 28V7H35Z" fill="#FA4729"/>
                                    </svg>
                                </div>
                                <div class="pxl-title1">
                                    <h2 class="pxl-item--title1 el-empty">"<?php echo pxl_print_html($title1); ?>"</h2>
                                </div>
                            </div>
                            <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>
            </div>

        </div>
        
        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-1">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev pxl-cursor--cta"><i class="flaticon-left-chevron rtl-icon"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next pxl-cursor--cta"><i class="flaticon-right-chevron rtl-icon"></i></div>
            </div>
        <?php endif; ?>
        
    </div>
<?php endif; ?>
