<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel6" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_attr__('DRAG', 'logiku'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">

            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                <?php foreach ($settings['testimonial'] as $key => $value):
                    $title = isset($value['title']) ? $value['title'] : '';
                    $title1 = isset($value['title1']) ? $value['title1'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    ?>
                    <div class="pxl-swiper-slide">
                        <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate']); ?>">
                            <div class="pxl-title-inner">
                                <div class="pxl-title1">
                                    <h2 class="pxl-item--title1 el-empty"><?php echo pxl_print_html($title1); ?></h2>
                                </div>
                                <div class="pxl-item--icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="49" height="49" viewBox="0 0 49 49" fill="none">
                                        <g clip-path="url(#clip0_548_12445)">
                                            <path d="M42.9704 22.6149H31.6606V18.845C31.6606 13.6481 35.8886 9.42009 41.0854 9.42009H46.7404C47.7814 9.42009 48.6253 8.57619 48.6253 7.53512C48.6253 6.49405 47.7814 5.65015 46.7404 5.65015H41.0854C33.8098 5.65015 27.8906 11.5693 27.8906 18.845V37.6947C27.8906 40.8128 30.4274 43.3496 33.5455 43.3496H42.9704C46.0885 43.3496 48.6253 40.8128 48.6253 37.6947V28.2698C48.6253 25.1517 46.0885 22.6149 42.9704 22.6149ZM44.8554 37.6947C44.8554 38.7341 44.0098 39.5797 42.9704 39.5797H33.5455C32.5062 39.5797 31.6606 38.7341 31.6606 37.6947V26.3849H42.9704C44.0098 26.3849 44.8554 27.2305 44.8554 28.2698V37.6947Z" fill="white"/>
                                            <path d="M13.5659 9.42009H19.2208C20.2619 9.42009 21.1058 8.57619 21.1058 7.53512C21.1058 6.49405 20.2619 5.65015 19.2208 5.65015H13.5659C6.29029 5.65015 0.371094 11.5693 0.371094 18.845V37.6947C0.371094 40.8128 2.90789 43.3496 6.02601 43.3496H15.4509C18.569 43.3496 21.1058 40.8128 21.1058 37.6947V28.2698C21.1058 25.1517 18.569 22.6149 15.4509 22.6149H4.14104V18.845C4.14104 13.6481 8.36904 9.42009 13.5659 9.42009ZM17.3359 28.2698V37.6947C17.3359 38.7341 16.4903 39.5797 15.4509 39.5797H6.02601C4.98664 39.5797 4.14104 38.7341 4.14104 37.6947V26.3849H15.4509C16.4903 26.3849 17.3359 27.2305 17.3359 28.2698Z" fill="white"/>
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_548_12445">
                                                <rect width="48.2553" height="48.2553" fill="white" transform="translate(0.371094 0.372314)"/>
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </div>
                            </div>
                            <div class="pxl-item-svg">
                                <svg xmlns="http://www.w3.org/2000/svg" width="120" height="24" viewBox="0 0 120 24" fill="none">
                                    <path d="M11.5244 1.46354C11.674 1.00288 12.3258 1.00288 12.4754 1.46354L14.5818 7.9463C14.6487 8.15231 14.8407 8.2918 15.0573 8.2918H21.8736C22.358 8.2918 22.5594 8.9116 22.1675 9.1963L16.653 13.2029C16.4778 13.3302 16.4044 13.5559 16.4714 13.7619L18.5777 20.2447C18.7274 20.7053 18.2002 21.0884 17.8083 20.8037L12.2938 16.7971C12.1185 16.6698 11.8812 16.6698 11.706 16.7971L6.19148 20.8037C5.79963 21.0884 5.27239 20.7053 5.42206 20.2447L7.52842 13.7619C7.59536 13.5559 7.52203 13.3302 7.34679 13.2029L1.83225 9.1963C1.4404 8.9116 1.64179 8.2918 2.12615 8.2918H8.94248C9.15909 8.2918 9.35107 8.15232 9.41801 7.9463L11.5244 1.46354Z" fill="#FF5E14"/>
                                    <path d="M35.5244 1.46354C35.674 1.00288 36.3258 1.00288 36.4754 1.46354L38.5818 7.9463C38.6487 8.15231 38.8407 8.2918 39.0573 8.2918H45.8736C46.358 8.2918 46.5594 8.9116 46.1675 9.1963L40.653 13.2029C40.4778 13.3302 40.4044 13.5559 40.4714 13.7619L42.5777 20.2447C42.7274 20.7053 42.2002 21.0884 41.8083 20.8037L36.2938 16.7971C36.1185 16.6698 35.8812 16.6698 35.706 16.7971L30.1915 20.8037C29.7996 21.0884 29.2724 20.7053 29.4221 20.2447L31.5284 13.7619C31.5954 13.5559 31.522 13.3302 31.3468 13.2029L25.8323 9.1963C25.4404 8.9116 25.6418 8.2918 26.1261 8.2918H32.9425C33.1591 8.2918 33.3511 8.15232 33.418 7.9463L35.5244 1.46354Z" fill="#FF5E14"/>
                                    <path d="M59.5244 1.46354C59.674 1.00288 60.3258 1.00288 60.4754 1.46354L62.5818 7.9463C62.6487 8.15231 62.8407 8.2918 63.0573 8.2918H69.8736C70.358 8.2918 70.5594 8.9116 70.1675 9.1963L64.653 13.2029C64.4778 13.3302 64.4044 13.5559 64.4714 13.7619L66.5777 20.2447C66.7274 20.7053 66.2002 21.0884 65.8083 20.8037L60.2938 16.7971C60.1185 16.6698 59.8812 16.6698 59.706 16.7971L54.1915 20.8037C53.7996 21.0884 53.2724 20.7053 53.4221 20.2447L55.5284 13.7619C55.5954 13.5559 55.522 13.3302 55.3468 13.2029L49.8323 9.1963C49.4404 8.9116 49.6418 8.2918 50.1261 8.2918H56.9425C57.1591 8.2918 57.3511 8.15232 57.418 7.9463L59.5244 1.46354Z" fill="#FF5E14"/>
                                    <path d="M107.524 1.46354C107.674 1.00288 108.326 1.00288 108.475 1.46354L110.582 7.9463C110.649 8.15231 110.841 8.2918 111.057 8.2918H117.874C118.358 8.2918 118.559 8.9116 118.168 9.1963L112.653 13.2029C112.478 13.3302 112.404 13.5559 112.471 13.7619L114.578 20.2447C114.727 20.7053 114.2 21.0884 113.808 20.8037L108.294 16.7971C108.119 16.6698 107.881 16.6698 107.706 16.7971L102.191 20.8037C101.8 21.0884 101.272 20.7053 101.422 20.2447L103.528 13.7619C103.595 13.5559 103.522 13.3302 103.347 13.2029L97.8323 9.1963C97.4404 8.9116 97.6418 8.2918 98.1261 8.2918H104.942C105.159 8.2918 105.351 8.15232 105.418 7.9463L107.524 1.46354Z" fill="#FF5E14"/>
                                    <path d="M83.5244 1.46354C83.674 1.00288 84.3258 1.00288 84.4754 1.46354L86.5818 7.9463C86.6487 8.15231 86.8407 8.2918 87.0573 8.2918H93.8736C94.358 8.2918 94.5594 8.9116 94.1675 9.1963L88.653 13.2029C88.4778 13.3302 88.4044 13.5559 88.4714 13.7619L90.5777 20.2447C90.7274 20.7053 90.2002 21.0884 89.8083 20.8037L84.2938 16.7971C84.1185 16.6698 83.8812 16.6698 83.706 16.7971L78.1915 20.8037C77.7996 21.0884 77.2724 20.7053 77.4221 20.2447L79.5284 13.7619C79.5954 13.5559 79.522 13.3302 79.3468 13.2029L73.8323 9.1963C73.4404 8.9116 73.6418 8.2918 74.1261 8.2918H80.9425C81.1591 8.2918 81.3511 8.15232 81.418 7.9463L83.5244 1.46354Z" fill="#FF5E14"/>
                                </svg>
                            </div>
                            <div class="pxl-item--desc el-empty"><?php echo pxl_print_html($desc); ?></div>
                            <div class="pxl-item--holder">
                                <?php if(!empty($image['id'])) { 
                                    $img = pxl_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => '128x128',
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail = $img['thumbnail'];?>
                                    <div class="pxl-item--avatar pxl-mr-18">
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    </div>
                                <?php } ?>
                                <div class="pxl-item--meta pxl-mr-20">
                                    <h6 class="pxl-item--title el-empty"><?php echo pxl_print_html($title); ?></h6>
                                    <?php if(!empty($position)) : ?>
                                        <div class="pxl-item--position"><?php echo pxl_print_html($position); ?></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>
            </div>

        </div>
        
        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>

        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-1">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev pxl-cursor--cta">
                    <svg xmlns="http://www.w3.org/2000/svg" width="51" height="52" viewBox="0 0 51 52" fill="none">
                        <rect width="49" height="50" transform="matrix(-1 0 0 1 50 1)" fill="white"/>
                        <rect x="0.5" y="-0.5" width="50" height="51" transform="matrix(-1 0 0 1 51 1)" stroke="#015388" stroke-opacity="0.27"/>
                        <path d="M17.9171 26.6364C17.5657 26.2849 17.5657 25.7151 17.9171 25.3636L23.6447 19.636C23.9962 19.2846 24.566 19.2846 24.9175 19.636C25.269 19.9875 25.269 20.5574 24.9175 20.9088L19.8263 26L24.9175 31.0912C25.269 31.4426 25.269 32.0125 24.9175 32.364C24.566 32.7154 23.9962 32.7154 23.6447 32.364L17.9171 26.6364ZM32 26V26.9H18.5535V26V25.1H32V26Z" fill="#FA4729"/>
                    </svg>
                </div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next pxl-cursor--cta">
                    <svg xmlns="http://www.w3.org/2000/svg" width="51" height="52" viewBox="0 0 51 52" fill="none">
                        <rect width="49" height="50" x="1" y="1" fill="white"/>
                        <rect x="0.5" y="0.5" width="50" height="51" stroke="#015388" stroke-opacity="0.27"/>
                        <path d="M33.0829 25.3636C33.4343 25.7151 33.4343 26.2849 33.0829 26.6364L27.3553 32.364C27.0038 32.7154 26.434 32.7154 26.0825 32.364C25.731 32.0125 25.731 31.4426 26.0825 31.0912L31.1737 26L26.0825 20.9088C25.731 20.5574 25.731 19.9875 26.0825 19.636C26.434 19.2846 27.0038 19.2846 27.3553 19.636L33.0829 25.3636ZM19 26V25.1H32.4465V26V26.9H19V26Z" fill="#FA4729"/>
                    </svg>
                </div>
            </div>
        <?php endif; ?>
        
    </div>
<?php endif; ?>
