<?php
pxl_add_custom_widget(
    array(
        'name' => 'pxl_showcase',
        'title' => esc_html__('Case Showcase', 'logiku'),
        'icon' => 'eicon-parallax',
        'categories' => array('pxltheme-core'),
        'script' => ['logiku-showcase'],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'section_layout',
                    'label' => esc_html__('Layout', 'logiku' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'logiku' ),
                            'type' => 'layoutcontrol',
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'logiku' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_showcase/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'logiku' ),
                                    'image' => get_template_directory_uri() . '/elements/assets/img/pxl_showcase/layout2.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_content',
                    'label' => esc_html__('Content', 'logiku'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'style-layout',
                            'label' => esc_html__('Style','logiku'),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'style-1' => esc_html__('Style 1','logiku'),
                                'style-2' => esc_html__('Style 2','logiku'),
                            ],
                            'default' => 'style-1',
                        ),
                        array(
                            'name' => 'max_height_image',
                            'label' => esc_html__('Max Height Image', 'logiku'),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-showcase .pxl-item--image' => 'max-height: {{SIZE}}{{UNIT}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Image', 'logiku' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'title',
                            'label' => esc_html__('Title', 'logiku'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link','logiku'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                            'condition' => [
                                'style-layout' => 'style-2',
                            ],
                        ),
                        array(
                            'name' => 'title_typography',
                            'label' => esc_html__('Title Typography', 'logiku' ),
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .pxl-showcase .pxl-item--title',
                            'condition' => [
                                'layout' => '2',
                            ],
                        ),
                        array(
                            'name' => 'btn_text',
                            'label' => esc_html__('Button Text 1', 'logiku'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'coming_soon' => 'no',
                                'style-layout' => ['style-1', 'style-2'],
                            ],
                        ),
                        array(
                            'name' => 'btn_link',
                            'label' => esc_html__('Button Link 1', 'logiku'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                            'condition' => [
                                'coming_soon' => 'no',
                                'style-layout' => ['style-1', 'style-2'],
                            ],
                        ),
                        array(
                            'name' => 'btn_text2',
                            'label' => esc_html__('Button Text 2', 'logiku'),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'condition' => [
                                'coming_soon' => 'no',
                                'style-layout' => ['style-1', 'style-2'],
                            ],
                        ),
                        array(
                            'name' => 'btn_link2',
                            'label' => esc_html__('Button Link 2', 'logiku'),
                            'type' => \Elementor\Controls_Manager::URL,
                            'label_block' => true,
                            'condition' => [
                                'coming_soon' => 'no',
                                'style-layout' => ['style-1', 'style-2'],
                            ],
                        ),
                        array(
                            'name' => 'coming_soon',
                            'label' => esc_html__('Coming Soon', 'logiku'),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'no',
                        )
                    ),
                ),
                array(
                    'name' =>'section_style', 
                    'label' => esc_html__('Style','logiku'),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'border_type',
                            'label' => esc_html__( 'Border Type', 'logiku' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                '' => esc_html__( 'None', 'logiku' ),
                                'solid' => esc_html__( 'Solid', 'logiku' ),
                                'double' => esc_html__( 'Double', 'logiku' ),
                                'dotted' => esc_html__( 'Dotted', 'logiku' ),
                                'dashed' => esc_html__( 'Dashed', 'logiku' ),
                                'groove' => esc_html__( 'Groove', 'logiku' ),
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .pxl-showcase' => 'border-style: {{VALUE}} !important;',
                            ],
                        ),
                        array(
                            'name' => 'border_width',
                            'label' => esc_html__( 'Border Width', 'logiku' ),
                            'type' => \Elementor\Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .pxl-showcase' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                            'responsive' => true,
                        ),
                        array(
                            'name' => 'border_color',
                            'label' => esc_html__( 'Border Color', 'logiku' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .pxl-showcase' => 'border-color: {{VALUE}} !important;',
                            ],
                            'condition' => [
                                'border_type!' => '',
                            ],
                        ),
                    ),
                ),
                logiku_widget_animation_settings(),
            ),
        ),
    ),
    logiku_get_class_widget_path()
);