<?php

if (!class_exists('Logiku_Blog')) {

    class Logiku_Blog
    {
        
        public function get_archive_meta($post_id = 0) {
            $archive_author = logiku()->get_theme_opt( 'archive_author', true );
            $archive_date = logiku()->get_theme_opt( 'archive_date', true );
            $archive_category = logiku()->get_theme_opt( 'archive_category', true );
            $archive_comment = logiku()->get_theme_opt( 'archive_comment', true );
            if($archive_author || $archive_category || $archive_date || $archive_comment) : ?>
                <div class="pxl-item--meta pxl-blog-meta">
                    <div class="pxl-blog-meta-inner">
                        <?php if($archive_date) : ?>
                            <div class="pxl-item--date pxl-mr-15">
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
                                    <path d="M14.2322 2.25781H12.3622V1.99219C12.3622 1.85129 12.3062 1.71617 12.2066 1.61654C12.107 1.51691 11.9718 1.46094 11.8309 1.46094C11.69 1.46094 11.5549 1.51691 11.4553 1.61654C11.3557 1.71617 11.2997 1.85129 11.2997 1.99219V2.25781H5.70031V1.99219C5.70031 1.85129 5.64434 1.71617 5.54471 1.61654C5.44508 1.51691 5.30996 1.46094 5.16906 1.46094C5.02817 1.46094 4.89304 1.51691 4.79341 1.61654C4.69378 1.71617 4.63781 1.85129 4.63781 1.99219V2.25781H2.76781C2.17507 2.25922 1.60701 2.4953 1.18787 2.91444C0.768741 3.33357 0.532653 3.90163 0.53125 4.49437V13.8125C0.532653 14.4052 0.768741 14.9733 1.18787 15.3924C1.60701 15.8116 2.17507 16.0477 2.76781 16.0491H14.2322C14.8249 16.0477 15.393 15.8116 15.8121 15.3924C16.2313 14.9733 16.4673 14.4052 16.4688 13.8125V4.49437C16.4673 3.90163 16.2313 3.33357 15.8121 2.91444C15.393 2.4953 14.8249 2.25922 14.2322 2.25781ZM2.76781 3.32031H4.63781V3.58594C4.63781 3.72683 4.69378 3.86196 4.79341 3.96159C4.89304 4.06122 5.02817 4.11719 5.16906 4.11719C5.30996 4.11719 5.44508 4.06122 5.54471 3.96159C5.64434 3.86196 5.70031 3.72683 5.70031 3.58594V3.32031H11.2997V3.58594C11.2997 3.72683 11.3557 3.86196 11.4553 3.96159C11.5549 4.06122 11.69 4.11719 11.8309 4.11719C11.9718 4.11719 12.107 4.06122 12.2066 3.96159C12.3062 3.86196 12.3622 3.72683 12.3622 3.58594V3.32031H14.2322C14.5436 3.32031 14.8422 3.44401 15.0624 3.66419C15.2826 3.88437 15.4062 4.18299 15.4062 4.49437V5.75344H1.59375V4.49437C1.59375 4.18299 1.71745 3.88437 1.93762 3.66419C2.1578 3.44401 2.45643 3.32031 2.76781 3.32031ZM14.2322 15.0078H2.76781C2.61183 15.0078 2.4574 14.9768 2.31356 14.9165C2.16971 14.8561 2.03932 14.7677 1.93002 14.6565C1.82072 14.5452 1.73468 14.4132 1.67695 14.2683C1.61921 14.1234 1.59093 13.9685 1.59375 13.8125V6.81594H15.4062V13.8125C15.4091 13.9685 15.3808 14.1234 15.3231 14.2683C15.2653 14.4132 15.1793 14.5452 15.07 14.6565C14.9607 14.7677 14.8303 14.8561 14.6864 14.9165C14.5426 14.9768 14.3882 15.0078 14.2322 15.0078Z" fill="#FA4729"/>
                                </svg>
                                <?php echo get_the_date('d M'); ?>, <?php echo get_the_date('Y'); ?>
                            </div>
                        <?php endif; ?>
                        <?php
if (!empty($archive_category) ) {
    $taxonomies = get_object_taxonomies(get_post_type($post_id));
    $output_terms = [];

    foreach ($taxonomies as $taxonomy) {
        $terms = get_the_terms($post_id, $taxonomy);
        if (!is_wp_error($terms) && !empty($terms)) {
            foreach ($terms as $term) {
                if (count($output_terms) < 1) {
                    $output_terms[] = $term->name;
                }
            }
        }
    }
}
    if (!empty($output_terms)) : ?>
        <span class="post-category">
            <span><?php echo esc_html(implode(', ', $output_terms)); ?></span>
        </span>
    <?php endif;
?>
                    </div>
                </div>
            <?php endif; 
        }

        public function get_post_metas(){
            $post_author = logiku()->get_theme_opt( 'post_author', true );
            $post_comment = logiku()->get_theme_opt( 'post_comment', true );
            $post_date = logiku()->get_theme_opt( 'post_date', true );
            $post_category = logiku()->get_theme_opt( 'post_category', true );
            if($post_author || $post_date) : ?>
                <div class="pxl-item--meta pxl-blog-meta">
                    <div class="pxl-blog-meta-inner">
                        <?php if($post_date) : ?>
                            <div class="pxl-item--date pxl-mr-30">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M6.75 0.75V2.25H11.25V0.75H12.75V2.25H15.75C16.1642 2.25 16.5 2.58579 16.5 3V15C16.5 15.4142 16.1642 15.75 15.75 15.75H2.25C1.83579 15.75 1.5 15.4142 1.5 15V3C1.5 2.58579 1.83579 2.25 2.25 2.25H5.25V0.75H6.75ZM15 8.25H3V14.25H15V8.25ZM5.25 3.75H3V6.75H15V3.75H12.75V5.25H11.25V3.75H6.75V5.25H5.25V3.75Z" fill="#FA4729"/>
                                </svg>
                                <?php echo get_the_date('M j, Y'); ?>
                            </div>
                        <?php endif; ?>
                        <?php if($post_category) : ?>
                            <div class="pxl-item--category">
                                <svg xmlns="http://www.w3.org/2000/svg" width="4" height="4" viewBox="0 0 4 4" fill="none">
                                    <circle cx="2" cy="2" r="2" fill="#898D90"/>
                                </svg>
                                <?php the_terms( get_the_ID(), 'category', '', ', ' ); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; 
        }

        public function get_excerpt(){
            $archive_excerpt_length = logiku()->get_theme_opt('archive_excerpt_length', '50');
            $logiku_the_excerpt = get_the_excerpt();
            if(!empty($logiku_the_excerpt)) {
                echo wp_trim_words( $logiku_the_excerpt, $archive_excerpt_length, $more = null );
            } else {
                echo wp_kses_post($this->get_excerpt_more( $archive_excerpt_length ));
            }
        }

        public function get_excerpt_more( $post = null ) {
            $archive_excerpt_length = logiku()->get_theme_opt('archive_excerpt_length', '50');
            $post = get_post( $post );

            if ( empty( $post ) || 0 >= $archive_excerpt_length ) {
                return '';
            }

            if ( post_password_required( $post ) ) {
                return esc_html__( 'Post password required.', 'logiku' );
            }

            $content = apply_filters( 'the_content', strip_shortcodes( $post->post_content ) );
            $content = str_replace( ']]>', ']]&gt;', $content );

            $excerpt_more = apply_filters( 'logiku_excerpt_more', '&hellip;' );
            $excerpt      = wp_trim_words( $content, $archive_excerpt_length, $excerpt_more );

            return $excerpt;
        }

        public function logiku_set_post_views( $postID ) {
            $countKey = 'post_views_count';
            $count    = get_post_meta( $postID, $countKey, true );
            if ( $count == '' ) {
                $count = 0;
                delete_post_meta( $postID, $countKey );
                add_post_meta( $postID, $countKey, '0' );
            } else {
                $count ++;
                update_post_meta( $postID, $countKey, $count );
            }
        }

        public function get_tagged_in(){
            $tags_list = get_the_tag_list( '<label class="label">'.esc_attr__('Tags:', 'logiku'). '</label>', ' ' );
            if ( $tags_list )
            {
                echo '<div class="pxl--tags pxl-mr-15">';
                printf('%2$s', '', $tags_list);
                echo '</div>';
            }
        }

        public function get_socials_share() { 
            $img_url = '';
            if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
                $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
            }
            $social_facebook = logiku()->get_theme_opt( 'social_facebook', true );
            $social_twitter = logiku()->get_theme_opt( 'social_twitter', true );
            $social_pinterest = logiku()->get_theme_opt( 'social_pinterest', true );
            $social_linkedin = logiku()->get_theme_opt( 'social_linkedin', true );
            ?>
            <div class="pxl--social">
                <label><?php echo esc_html__('Share:', 'logiku'); ?></label>
                <?php if($social_facebook) : ?>
                    <a class="fb-social" title="<?php echo esc_attr__('Facebook', 'logiku'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="caseicon-facebook"></i></a>
                <?php endif; ?>
                <?php if($social_twitter) : ?>
                    <a class="tw-social" title="<?php echo esc_attr__('Twitter', 'logiku'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>%20"><i class="caseicon-twitter"></i></a>
                <?php endif; ?>
                <?php if($social_pinterest) : ?>
                    <a class="pin-social" title="<?php echo esc_attr__('Pinterest', 'logiku'); ?>" target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url[0]); ?>&description=<?php the_title(); ?>%20"><i class="caseicon-pinterest"></i></a>
                <?php endif; ?>
                <?php if($social_linkedin) : ?>
                    <a class="lin-social" title="<?php echo esc_attr__('LinkedIn', 'logiku'); ?>" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>%20"><i class="caseicon-linkedin"></i></a>
                <?php endif; ?>
            </div>
            <?php
        }

        public function get_socials_share_portfolio() { 
            $img_url = '';
            if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
                $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
            }
            ?>
            <div class="pxl--social">
                <a class="fb-social" title="<?php echo esc_attr__('Facebook', 'logiku'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="caseicon-facebook"></i></a>
                <a class="tw-social" title="<?php echo esc_attr__('Twitter', 'logiku'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>%20"><i class="caseicon-twitter"></i></a>
                <a class="pin-social" title="<?php echo esc_attr__('Pinterest', 'logiku'); ?>" target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url[0]); ?>&description=<?php the_title(); ?>%20"><i class="caseicon-pinterest"></i></a>
                <a class="lin-social" title="<?php echo esc_attr__('LinkedIn', 'logiku'); ?>" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>%20"><i class="caseicon-linkedin"></i></a>
            </div>
            <?php
        }

        public function get_post_nav() {
            global $post;
            $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
            $next     = get_adjacent_post( false, '', false );

            if ( ! $next && ! $previous )
                return;
            ?>
            <?php
            $next_post = get_next_post();
            $previous_post = get_previous_post();

            if( !empty($next_post) || !empty($previous_post) ) { 
                $page_for_posts = get_option( 'page_for_posts' );
                ?>
                <div class="pxl-post--navigation pxl-flex">
                    
                    <?php if ( is_a( $previous_post , 'WP_Post' ) && get_the_title( $previous_post->ID ) != '') { 
                        $prev_img_id = get_post_thumbnail_id($previous_post->ID);
                        $img_prev  = pxl_get_image_by_size( array(
                            'attach_id'  => $prev_img_id,
                            'thumb_size' => '260x260',
                        ) );
                        $thumbnail_prev    = $img_prev['url']; ?>
                        <div class="pxl-navigation--col pxl-navigation--prev">
                            <div class="pxl-navigation--image bg-image pxl-mr-15" style="background-image: url(<?php echo esc_url($thumbnail_prev); ?>);">
                                <div class="pxl-navigation--icon"><i class="flaticon-left-arrow"></i></div>
                                <a href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>" class="pxl-navigation--link"></a>
                            </div>
                            <div class="pxl-navigation--meta">
                                <div class="pxl-navigation--date"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $previous_post->ID); ?></div>
                                <h5 class="pxl-navigation--title">
                                    <a  href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><?php echo get_the_title( $previous_post->ID ); ?></a>
                                </h5>
                            </div>
                        </div>
                    <?php } ?>
                    
                    <?php if ( is_a( $next_post , 'WP_Post' ) && get_the_title( $next_post->ID ) != '') { 
                        $next_img_id = get_post_thumbnail_id($next_post->ID);
                        $img_next  = pxl_get_image_by_size( array(
                            'attach_id'  => $next_img_id,
                            'thumb_size' => '260x260',
                        ) );
                        $thumbnail_next    = $img_next['url']; ?>
                        <div class="pxl-navigation--col pxl-navigation--next">
                            <div class="pxl-navigation--meta pxl-text-right">
                                <div class="pxl-navigation--date"><?php $date_formart = get_option('date_format'); echo get_the_date($date_formart, $next_post->ID); ?></div>
                                <h5 class="pxl-navigation--title">
                                    <a  href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"><?php echo get_the_title( $next_post->ID ); ?></a>
                                </h5>
                            </div>
                            <div class="pxl-navigation--image bg-image pxl-ml-15" style="background-image: url(<?php echo esc_url($thumbnail_next); ?>);">
                                <div class="pxl-navigation--icon"><i class="flaticon-right-arrow-6"></i></div>
                                <a href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>" class="pxl-navigation--link"></a>
                            </div>
                        </div>
                    <?php } ?>
                    
                </div>
            <?php }
        }

        public function get_post_author_info() { ?>
            <div class="pxl-post--author-info pxl-item--flexnw">
                <div class="pxl-post--author-image pxl-mr-30"><?php echo get_avatar( get_the_author_meta( 'ID' ), 280 ); ?></div>
                <div class="pxl-post--author-meta">
                    <?php logiku_get_user_name(); ?>
                    <div class="pxl-post--author-description"><?php the_author_meta( 'description' ); ?></div>
                    <?php logiku_get_user_social(); ?>
                </div>
            </div>
        <?php }

        public function get_related_post(){
            $post_related_on = logiku()->get_theme_opt( 'post_related_on', false );

            if($post_related_on) {
                global $post;
                $current_id = $post->ID;
                $posttags = get_the_category($post->ID);
                if (empty($posttags)) return;

                $tags = array();

                foreach ($posttags as $tag) {

                    $tags[] = $tag->term_id;
                }
                $post_number = '6';
                $query_similar = new WP_Query(array('posts_per_page' => $post_number, 'post_type' => 'post', 'post_status' => 'publish', 'category__in' => $tags));
                if (count($query_similar->posts) > 1) {
                    wp_enqueue_script( 'swiper' );
                    wp_enqueue_script( 'pxl-swiper' );
                    $opts = [
                        'slide_direction'               => 'horizontal',
                        'slide_percolumn'               => '1', 
                        'slide_mode'                    => 'slide', 
                        'slides_to_show'                => 3, 
                        'slides_to_show_lg'             => 3, 
                        'slides_to_show_md'             => 2, 
                        'slides_to_show_sm'             => 2, 
                        'slides_to_show_xs'             => 1, 
                        'slides_to_scroll'              => 1, 
                        'slides_gutter'                 => 30, 
                        'arrow'                         => false,
                        'dots'                          => true,
                        'dots_style'                    => 'bullets'
                    ];
                    $data_settings = wp_json_encode($opts);
                    $dir           = is_rtl() ? 'rtl' : 'ltr';
                    ?>
                    <div class="pxl-related-post">
                        <h4 class="widget-title"><?php echo esc_html__('Related Posts', 'logiku'); ?></h4>
                        <div class="class" data-settings="<?php echo esc_attr($data_settings) ?>" data-rtl="<?php echo esc_attr($dir) ?>">
                            <div class="pxl-related-post-inner pxl-swiper-wrapper swiper-wrapper">
                            <?php foreach ($query_similar->posts as $post):
                                $thumbnail_url = '';
                                if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)) :
                                    $thumbnail_url = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'pxl-blog-small', false);
                                endif;
                                if ($post->ID !== $current_id) : ?>
                                    <div class="pxl-swiper-slide swiper-slide grid-item">
                                        <div class="pxl-grid-item-inner">
                                            <?php if (has_post_thumbnail()) { ?>
                                                <div class="item-featured">
                                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url($thumbnail_url[0]); ?>" /></a>
                                                </div>
                                            <?php } ?>
                                            <h3 class="item-title">
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h3>
                                        </div>
                                    </div>
                                <?php endif;
                            endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php }
            }

            wp_reset_postdata();
        }
    }
}
